#include <iostream>
#include <vector>
#include <algorithm>;
using namespace std;
struct jar
{
	int s;
	int h;
	int i;
	bool operator<(const jar& other) const {
		return s < other.s;
	}
};
static vector<int> najvecidesni(vector<jar> jarboli,int n)
{
	vector<int> stack;
	vector<int> resenje;
	for (size_t i = 0; i < n; i++)
		resenje.push_back(-1);
	for (size_t i = 0; i < n; i++)
	{
		if (stack.size() == 0 || jarboli[stack.back()].h > jarboli[i].h)
		{
			stack.push_back(i);
		}
		else
		{
			int j = stack.size() - 1;
			while (j >= 0 && jarboli[stack[j]].h <= jarboli[i].h)
			{
				resenje[stack[j]] = i;
				stack.pop_back();
				j--;
			}
			stack.push_back(i);
		}
	}
	return resenje;
}
static vector<int> prvivecilevi(vector<jar> jarboli,int n)
{
	vector<int> resenja, stack;
	for (size_t i = 0; i < n; i++)
		resenja.push_back(-1);
	for (int i = n - 1; i > -1; i--)
	{
		if (stack.size() == 0 || jarboli[stack.back()].h > jarboli[i].h)
			stack.push_back(i);
		else
		{
			int j = stack.size() - 1;

			while (j >= 0 && jarboli[stack[j]].h <= jarboli[i].h)
			{
				resenja[stack[j]] = i;
				stack.pop_back();
				j--;
			}
			stack.push_back(i);
		}
	}
	return resenja;
}
static vector<int> glavni(vector<jar> jarboli, vector<int> idxvecidesno, vector<int> idxvecilevo, int n)
{
	int r;
	vector<int> resenja;
	for (size_t i = 0; i < n; i++)
		resenja.push_back(-1);
	for (size_t i = 0; i < n; i++)
	{
		if (idxvecidesno[i] != -1)
		{
		    r = jarboli[idxvecidesno[i]].s - jarboli[i].s - jarboli[idxvecidesno[i]].h + jarboli[i].h;
			if (r != 0)
				resenja[jarboli[i].i] = r;
			else if(i < n - 1)
				resenja[jarboli[i].i] = jarboli[i].s - jarboli[i + 1].s;
		}
		if (idxvecilevo[i] != -1)
		{
			r = jarboli[i].s - jarboli[idxvecilevo[i]].s - jarboli[idxvecilevo[i]].h + jarboli[i].h;
			if (r != 0)
			{
				if (resenja[jarboli[i].i] != -1)
					resenja[jarboli[i].i] = min(resenja[jarboli[i].i], r);
				else
					resenja[jarboli[i].i] = r;
			}
			else if (i > 0)
			{
				if (resenja[jarboli[i].i] != -1)
					resenja[jarboli[i].i] = min(resenja[jarboli[i].i], jarboli[i - 1].s - jarboli[i].s);
				else
					resenja[jarboli[i].i] = jarboli[i - 1].s - jarboli[i].s;
			}			
		}
	}
	return resenja;
}
int main()
{
	int n, temp;
	cin >> n;
	vector<jar> jarboli;
	jarboli.reserve(n);
	for (int i = 0; i < n; i++)
	{
		cin >> temp;
		jarboli.emplace_back(jar{ temp, -1, i });
	}
	for (size_t i = 0; i < n; i++)
	{
		cin >> temp;
		jarboli[i].h = temp;
	}
	sort(jarboli.begin(), jarboli.end());
	vector<int> idxvecidesno, idxvecilevo;
	idxvecidesno = najvecidesni(jarboli, n);
	idxvecilevo = prvivecilevi(jarboli, n);
	vector<int> res = glavni(jarboli, idxvecidesno, idxvecilevo, n);
	for (size_t i = 0; i < n; i++)
	{
		cout << res[i] << " ";
	}
}